@extends('main-admin')

@section('content')
<!-- start page title -->
<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <h4 class="page-title">Flashsale</h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item active">Admin/Flashsale</li>
                </ol>
            </div>
        </div>
    </div>
</div>
@if(session('success'))
<div class="alert alert-success">
    {{ session('success') }}
</div>
@endif
<div class="card">
    <div class="card-body">
        <h4 class="mb-3 header-title mt-0">Tambah Flashsale</h4>
        <form action="{{ route('promo.post') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="mb-3 row">
                <label class="col-lg-2 col-form-label" for="example-fileinput">Nama Flashsale</label>
                <div class="col-lg-10">
                    <input type="text" class="form-control @error('nama') is-invalid @enderror" value="{{ old('nama') }}" name="nama">
                    @error('nama')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                    @enderror
                </div>
            </div>
            
            <div class="mb-3 row">
                <label class="col-lg-2 col-form-label" for="example-fileinput">Kategori Produk</label>
                <div class="col-lg-10">
                    <select class="form-select" onchange="get_layanan(this.value)" name="kategori_id">
                        <option value="" disabled selected>--Pilih Kategori--</option>
                        @foreach ($kategoris as $item)
                        <option value="{{ $item->id }}">{{ $item->nama }}</option>
                        @endforeach
                    </select>
                    @error('kategori_id')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                    @enderror
                </div>
            </div>
            
            <div class="mb-3 row">
                <label class="col-lg-2 col-form-label" for="example-fileinput">Layanan Produk</label>
                <div class="col-lg-10">
                    <select class="form-select @error('layanan_id') is-invalid @enderror" name="layanan_id" id="layanan" onchange="get_harga(this.value)">
                        <option value="" selected disabled>Pilih Kategori Terlebih Dahulu</option>
                    </select>
                    @error('layanan_id')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                    @enderror
                </div>
            </div>

            <div class="mb-3 row">
                
                <label class="col-lg-1 col-form-label" for="example-fileinput">Harga Guest/Member</label>
                <div class="col-lg-5">
                    <input type="number" class="form-control" id="harga_member" readonly>
                </div>
            </div>
            
            <div class="mb-3 row">
                <label class="col-lg-1 col-form-label" for="example-fileinput">Harga Normal Gold</label>
                <div class="col-lg-5">
                    <input type="number" class="form-control" id="harga_gold" readonly>
                </div>
                <label class="col-lg-1 col-form-label" for="example-fileinput">Harga Normal Platinum</label>
                <div class="col-lg-5">
                    <input type="number" class="form-control" id="harga_platinum" readonly>
                </div>
            </div>
            
            <div class="mb-3 row">
                <label class="col-lg-1 col-form-label" for="example-fileinput">Harga Flashsale</label>
                <div class="col-lg-5">
                    <input type="number" class="form-control @error('harga_promo') is-invalid @enderror" value="{{ old('harga_promo') }}" name="harga_promo">
                    @error('harga_promo')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                    @enderror
                </div>
                <label class="col-lg-1 col-form-label" for="example-fileinput">Expired Flashsale</label>
                <div class="col-lg-5">
                    <input type="date" class="form-control @error('expired_flash_sale') is-invalid @enderror" value="{{ old('expired_flash_sale') }}" name="expired_flash_sale">
                    @error('expired_flash_sale')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                    @enderror
                </div>
            </div>    
            
            <div class="mb-3 row">
                <label class="col-lg-2 col-form-label" for="example-fileinput">Thumbnail</label>
                <div class="col-lg-10">
                    <input type="file" class="form-control" name="thumbnail">
                    @error('thumbnail')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                    @enderror
                </div>
            </div>

            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>
</div>
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title mt-0 mb-1">Semua Flashsale</h4>
                <div class="table-responsive">
                    <table class="table m-0">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Nama</th>
                                <th>Url</th>
                                <th>Kategori Produk</th>
                                <th>Layanan Produk</th>
                                <th>Harga Flashsale</th>
                                <th>Harga Normal Public</th>
                                <th>Harga Normal Member</th>
                                <th>Harga Normal Gold</th>
                                <th>Harga Normal Platinum</th>
                                <th>Thumbnail</th>
                                <th>Aksi</th>
                                <th>Tanggal</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no=1;?>
                            @foreach( $data as $datas )
                            <?php 
                            $layanan = DB::table('layanans')->where('id', $datas->id_layanan)->first(); 
                            $kategori = DB::table('kategoris')->where('id', $datas->id_kategori)->first(); 
                            ?>
                            @php
                            $label_pesanan = '';
                            if($datas->status == "active"){
                            $label_pesanan = 'info';
                            }else if($datas->status == "unactive"){
                            $label_pesanan = 'warning';
                            }
                            
                            @endphp
                            
                            <tr>
                                <th scope="row">{{ $no }}</th>
                                <td>{{ $datas->nama }}</td>
                                <td>{{ $datas->url }}</td>
                                <td>{{ $kategori->nama }}</td>
                                <td>{{ $layanan->layanan }}</td>
                                <td>{{ $datas->harga_promo }}</td>
                                <td><font class="text-danger"><del>{{ $layanan->harga }}</del></font></td>
                                <td><font class="text-danger"><del>{{ $layanan->harga_member }}</del></font></td>
                                <td><font class="text-danger"><del>{{ $layanan->harga_gold }}</del></font></td>
                                <td><font class="text-danger"><del>{{ $layanan->harga_platinum }}</del></font></td>
                                <td><img  width="150"src="{{ $datas->thumbnail }}" alt="{{ $datas->nama }}"></td>
                                <td>
                                    <a href="javascript:;" onclick="modal('{{ $datas->nama }}', '{{ route('promo.detail', [$datas->id]) }}')" class="btn-sm btn-info mb-3">Edit</a>
                                    <br>
                                     <br>
                                    <a class="btn-sm btn-danger mt-2" href="/promo/hapus/{{ $datas->id }}">Hapus</a>
                                </td>
                                <td>{{ $datas->created_at }}</td>
                            </tr>
                            <?php $no++ ;?>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
            </div>
        </div>

    </div>
</div>
<script type="text/javascript">
    $(document).ready(function(){
        $('.table').DataTable({
           
        });
    });
    function get_harga(layanan_id) {
        let harga_normal = $('#harga_normal')
        let harga_member = $('#harga_member')
        let harga_gold = $('#harga_gold')
        let harga_platinum = $('#harga_platinum')
        $.ajax({
            url: "{{ route('paket-layanan.get-harga') }}",
            method: "POST",
            headers: {
                'X-CSRF-TOKEN': "{{ csrf_token() }}"
            },
            data: {
                layanan_id: layanan_id
            },
            beforeSend: function() {
                harga_normal.val('0');
                harga_member.val('0');
                harga_gold.val('0');
                harga_platinum.val('0');
            },
            success: function(response) {
                var data = response.data;
                harga_normal.empty();
                harga_member.empty();
                harga_gold.empty();
                harga_platinum.empty();
                $.each(data, function(index, item) {
                    $('#harga_normal').val(item.harga);
                    $('#harga_member').val(item.harga_member);
                    $('#harga_gold').val(item.harga_gold);
                    $('#harga_platinum').val(item.harga_platinum);
                });
            },
            error: function(response) {
                let res = JSON.parse(response.responseText)
                $('#harga_normal').val('0');
                $('#harga_member').val('0');
                $('#harga_gold').val('0');
                $('#harga_platinum').val('0');
            }
        });
    }
    function get_layanan(kategori_id) {
        let layanan = $('#layanan')
        $.ajax({
            url: "{{ route('paket-layanan.get-layanan') }}",
            method: "POST",
            headers: {
                'X-CSRF-TOKEN': "{{ csrf_token() }}"
            },
            data: {
                kategori_id: kategori_id
            },
            beforeSend: function() {
                layanan.html('<option value="">Mengambil Layanan...</option>');
            },
            success: function(response) {
                var data = response.data;
                layanan.empty();
                layanan.html('<option value="" selected disabled>- Select One -</option>');
                $.each(data, function(index, item) {
                    layanan.append('<option value="' + item.id + '">' + item.layanan +
                        '</option>');
                });
            },
            error: function(response) {
                let res = JSON.parse(response.responseText)
                layanan.html('<option value="">' + res.message + '</option>');
            }
        });
    }
    function modal(name, link) {
        var myModal = new bootstrap.Modal($('#modal-detail'))
        $.ajax({
            type: "GET",
            url: link,
            beforeSend: function() {
                $('#modal-detail-title').html(name);
                $('#modal-detail-body').html('Loading...');
            },
            success: function(result) {
                $('#modal-detail-title').html(name);
                $('#modal-detail-body').html(result);
            },
            error: function() {
                $('#modal-detail-title').html(name);
                $('#modal-detail-body').html('There is an error...');
            }
        });
        myModal.show();
    }
</script>

<div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" id="modal-detail" style="border-radius:7%">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="modal-detail-title"></h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="modal-detail-body"></div>
        </div>
    </div>
</div>
@endsection